<?php

class EasySocialMetricsPro_Updater {
	private static $instance = null;
	
	protected $esmp_options;
	
	public static function get_instance() {
	
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
	
		return self::$instance;
	
	} // end get_instance;
	
	function __construct() {
		add_action( 'easy_social_metrics_pro_update_single', array( $this, 'updateSinglePostStatus' ), 10, 1 );		
		add_action( 'easy_social_metrics_pro_daily_update', array( $this, 'executeFullUpdate' ) );
		
		$this->esmp_options = EasySocialMetricsPro_Options::get_instance();
		
		$is_active = $this->esmp_options->get_options_key('active');
		$is_run_initial = $this->esmp_options->get_options_key('initial');
		
		if ($is_active == 'true') {
			$this->setupDailyFullUpdate();
		}
		
		//print '$is_run_initial = '.$is_run_initial;
		
		//print_r($this->esmp_options->options);
		
		if ($is_active == 'true' && $is_run_initial == 'false') {
			$this->esmp_options->set_initial_run_state();
			$this->scheduleFullUpdate();
		}
	}
	
	function scheduleFullUpdate() {
		$post_types = $this->esmp_options->get_monitored_post_types();

		$nextTime = time();
		$interval = 5; // in seconds
		// In case the function does not finish, we want to start with posts that have NO data yet.
		$querydata = query_posts(array(
				'order'			=>'DESC',
				'orderby'		=>'post_date',
				'posts_per_page'=>-1,
				'post_status'   => 'publish',
				'post_type'		=> $post_types
		));
		
		foreach ($querydata as $querydatum ) {				
			wp_schedule_single_event( $nextTime, 'easy_social_metrics_pro_update_single', array( $querydatum->ID ) );
			$nextTime = $nextTime + $interval;
		}
	}
	
	function updateSinglePostStatus($post_id) {
		global $blog_id;
		if ($post_id <= 0) return false;
		
		// Remove secure protocol from URL
		//$permalink = str_replace("https://", "http://", get_permalink($post_id));
		$permalink = get_permalink($post_id);
		
		// update social status for single post
		$updater = EasySocialMetricsPro_SocialUpdater::get_instance();
		$updater->update_all($permalink, $blog_id, $post_id);
	}
	
	function executeFullUpdate() {
		$this->scheduleFullUpdate();	
	}
	
	function setupDailyFullUpdate() {
		if ( ! wp_next_scheduled( 'easy_social_metrics_pro_daily_update' ) ) {
			wp_schedule_event( time(), 'daily',  'easy_social_metrics_pro_daily_update');
		}	
	}
	
	public static function deactivateAllCronJobs() {
		$crons = _get_cron_array();
		if ( !empty( $crons ) ) {
			foreach( $crons as $timestamp => $cron ) {
				// Remove single post updates
				if ( ! empty( $cron['easy_social_metrics_pro_update_single'] ) )  {
					unset( $crons[$timestamp]['easy_social_metrics_pro_update_single'] );
				}
		
				// Remove full post updates
				if ( ! empty( $cron['easy_social_metrics_pro_daily_update'] ) )  {
					unset( $crons[$timestamp]['easy_social_metrics_pro_daily_update'] );
				}
			}
			_set_cron_array( $crons );
				
			wp_clear_scheduled_hook('easy_social_metrics_pro_daily_update');
			wp_clear_scheduled_hook('easy_social_metrics_pro_update_single');
		}
		
		return;
	}

	public static function deactivateSingleCronJobs() {
		$crons = _get_cron_array();
		if ( !empty( $crons ) ) {
			foreach( $crons as $timestamp => $cron ) {
				// Remove single post updates
				if ( ! empty( $cron['easy_social_metrics_pro_update_single'] ) )  {
					unset( $crons[$timestamp]['easy_social_metrics_pro_update_single'] );
				}
	
			}
			_set_cron_array( $crons );
	
			wp_clear_scheduled_hook('easy_social_metrics_pro_update_single');
		}
	
		return;
	}
	
	
	public static function printQueueLength() {
		$queue = array();
		$cron = _get_cron_array();
		foreach ( $cron as $timestamp => $cronhooks ) {
			foreach ( (array) $cronhooks as $hook => $events ) {
				foreach ( (array) $events as $key => $event ) {
					if ($hook == 'easy_social_metrics_pro_update_single') {
						array_push($queue, $cron[$timestamp][$hook][$key]['args'][0]);
					}
				}
			}
		}
	
		$count = count($queue);
		if ($count >= 1) {
			$label = ($count >=2) ? ' items' : ' item';
			printf( '<div class="updated"> <p> %s </p> </div>',  'Currently updating <b>'.$count . $label.'</b> with the most recent social and analytics data... <a href="'.admin_url('admin.php?page=easy-social-metrics-pro&esmp_sync_cancel=true').'" class="button">Cancel pending updates</a>');
		}
	} // end printQueueLength()
	
	public static function getNextFullUpdate() {
		$next_schedule = '';
		$queue = array();
		$cron = _get_cron_array();
		foreach ( $cron as $timestamp => $cronhooks ) {
			foreach ( (array) $cronhooks as $hook => $events ) {
				foreach ( (array) $events as $key => $event ) {
					if ($hook == 'easy_social_metrics_pro_daily_update') {
						$next_schedule = $timestamp;
					}
				}
			}
		}
		
		if ($next_schedule != '') {
			$next_schedule = date('l jS \of F Y H:i', $next_schedule);
		}
		
		return $next_schedule;
	}
}

?>