<?php

class EasySocialMetricsPro_ReportHelper {
	
	public static function sqlCreatePostChangesValue($object) {
		$data_object = array ();
		
		$firstAllocatedDate = EasySocialMetricsPro_DatabaseHelper::getFirstDatabaseRecord();
		
		$isAllocatedInThisPeriod = false;
		
		$options = EasySocialMetricsPro_Options::get_instance ();
		$network_list = $options->get_options_key ( 'networks' );
		$active_networks = $options->get_options_key ( 'active_networks' );
		
		foreach ( $object as $single ) {
			$date = $single->esmp_date;
			$serialized_data = $single->esmp_data;
			$post_id = $single->esmp_post_id;
			
			if ($date == $firstAllocatedDate) {
				$isAllocatedInThisPeriod = true;
			}
 			
			$date_data = unserialize ( $serialized_data );
			
			$publish_date = get_the_date( 'Y-m-d', $post_id );
			$isPublishedInPeriod = false;
			if ($publish_date == $date) { 
				$isPublishedInPeriod = true;
			}
			
			$total = EasySocialMetricsPro_ReportHelper::aggregateTotalFromObject ( $date_data );
			
			if (! isset ( $data_object [$post_id] )) {
				$data_object [$post_id] = array ('name' => '', 'max_value' => 0, 'min_value' => -1, 'diff_value' => 0, 'post_id' => $post_id, 'count' => 0 );
				if ($isAllocatedInThisPeriod) {
					$data_object [$post_id]['min_value'] = 0;
				}
				if ($isPublishedInPeriod) {
					$data_object [$post_id]['min_value'] = 0;
				}
				
				foreach ( $network_list as $key => $name ) {
					
					if (in_array ( $key, $active_networks )) {
						$data_object [$post_id] [$key] = array ('name' => $name, 'max_value' => 0, 'min_value' => -1, 'diff_value' => 0 );
						
						if ($isAllocatedInThisPeriod) {
							$data_object [$post_id][$key]['min_value'] = 0;
						}
						if ($isPublishedInPeriod) {
							$data_object [$post_id][$key]['min_value'] = 0;
						}
					}
				}
			}
			
			foreach ( $date_data as $network => $data ) {
				$single = isset ( $data ['count'] ) ? $data ['count'] : 0;
				$single = intval ( $single );
				
				if (in_array ( $network, $active_networks )) {
					$current = $data_object [$post_id] [$network] ['max_value'];
					
					if (intval ( $single ) > intval ( $current )) {
						$data_object [$post_id] [$network] ['max_value'] = $single;
					}
					
					$current = $data_object [$post_id] [$network] ['min_value'];
					
					if ($current == -1) {
						$data_object [$post_id] [$network] ['min_value'] = $single;
					}
					else {
						if (intval ( $single ) < intval ( $current )) {
							$data_object [$post_id] [$network] ['min_value'] = $single;
						}
					}
				}
			}
			
			$current = $data_object [$post_id] ['max_value'];
			
			if (intval ( $total ) > intval ( $current )) {
				$data_object [$post_id] ['max_value'] = $total;
			}
			
			$current = $data_object [$post_id] ['min_value'];
			
			if ($current == -1) {
				$data_object [$post_id] ['min_value'] = $total;
			}
			else {
				if (intval ( $total ) < intval ( $current )) {
					$data_object [$post_id] ['min_value'] = $total;
				}
			}
			$data_object [$post_id]['count']++;
		}
		
		foreach ( $data_object as $post_id => $data ) {
			$min_value = $data ['min_value'];
			$max_value = $data ['max_value'];
			
			$diff = intval ( $max_value ) - intval ( $min_value );
			
			$count_value = $data['count'];		
			
			$data_object [$post_id] ['diff_value'] = $diff;
			
			foreach ( $network_list as $key => $name ) {
				if (in_array ( $key, $active_networks )) {
				$min_value = $data_object [$post_id] [$key] ['min_value'];
				$max_value = $data_object [$post_id] [$key] ['max_value'];
				
				$diff = intval ( $max_value ) - intval ( $min_value );
				
				$data_object [$post_id] [$key] ['diff_value'] = $diff;
				}
			}
		}
		
		usort ( $data_object, "uSortByDiffValue" );
		
		return $data_object;
	
	}
	
	public static function sqlCreateNetworkChangesValues($object) {
		$data_object = array ();
		$options = EasySocialMetricsPro_Options::get_instance ();
		$network_list = $options->get_options_key ( 'networks' );
		
		foreach ( $network_list as $key => $name ) {
			$data_object [$key] = array ('name' => $name, 'max_value' => 0, 'min_value' => 0, 'diff_value' => 0 );
		}
		
		$exist_data = array ();
		
		foreach ( $object as $single ) {
			$date = $single->esmp_date;
			$serialized_data = $single->esmp_data;
			
			$date_data = unserialize ( $serialized_data );
			
			foreach ( $date_data as $network => $data ) {
				$single = isset ( $data ['count'] ) ? $data ['count'] : 0;
				$single = intval ( $single );
				
				$current = $data_object [$network] ['max_value'];
				
				if (intval ( $single ) > intval ( $current )) {
					$data_object [$network] ['max_value'] = $single;
				}
				
				$current = $data_object [$network] ['min_value'];
				
				if (intval ( $single ) < intval ( $current )) {
					$data_object [$network] ['min_value'] = $single;
				}
			}
		}
		
		foreach ( $data_object as $network => $data ) {
			$min_value = $data ['min_value'];
			$max_value = $data ['max_value'];
			
			$diff = intval ( $max_value ) - intval ( $min_value );
			
			$data_object [$network] ['diff_value'] = $diff;
		}
		
		return $data_object;
	}
	
	public static function sqlCreateChangesInObject($fromDate, $toDate, $object) {
		$exist_dates = array ();
		
		foreach ( $object as $single ) {
			$date = $single->esmp_date;
			$serialized_data = $single->esmp_data;
			
			$date_data = unserialize ( $serialized_data );
			
			$total = EasySocialMetricsPro_ReportHelper::aggregateTotalFromObject ( $date_data );
			
			if (! isset ( $exist_dates [$date] )) {
				$exist_dates [$date] = 0;
			}
			
			$exist_dates [$date] += $total;
		}
		
		$output = array ();
		
		$previous_value = - 1;
		while ( $fromDate <= $toDate ) {
			
			$current_value = 0;
			
			if (isset ( $exist_dates [$fromDate] )) {
				$current_value = $exist_dates [$fromDate];
			} else {
				$current_value = '0';
			}
			
			if ($previous_value == - 1) {
				$output [$fromDate] = 0;
				$previous_value = $current_value;
			} else {
				$diff = intval ( $current_value ) - intval ( $previous_value );
				$output [$fromDate] = $diff;
				$previous_value = $current_value;
			}
			
			$fromDate = date ( 'Y-m-d', strtotime ( $fromDate . ' +1 day' ) );
		
		}
		
		return $output;
	
	}
	
	public static function sqlDateRangeRecordConvert($fromDate, $toDate, $object) {
		$exist_dates = array ();
		
		foreach ( $object as $single ) {
			$date = $single->esmp_date;
			$serialized_data = $single->esmp_data;
			
			$date_data = unserialize ( $serialized_data );
			
			$total = EasySocialMetricsPro_ReportHelper::aggregateTotalFromObject ( $date_data );
			
			if (! isset ( $exist_dates [$date] )) {
				$exist_dates [$date] = 0;
			}
			
			$exist_dates [$date] += $total;
		}
		
		$output = array ();
		
		while ( $fromDate <= $toDate ) {
			if (isset ( $exist_dates [$fromDate] )) {
				$output [$fromDate] = $exist_dates [$fromDate];
			} else {
				$output [$fromDate] = '0';
			}
			
			$fromDate = date ( 'Y-m-d', strtotime ( $fromDate . ' +1 day' ) );
		
		}
		
		return $output;
	}
	
	public static function keyObjectToMorrisLineGraphMulti($chart_id, $object, $labelsObject) {
		$output = "";
		$output .= "Morris.Bar({
		element: '" . $chart_id . "',
		data: [";
		
		$xKeysObject = array();
	
		$is_passedOne = false;
		foreach ( $object as $key => $value ) {
			$oneValue = $value['all'];
			if ($oneValue == 0 && !$is_passedOne) {
				$is_passedOne = true;
				continue;
			}
			$is_passedOne = true;
				
			//$output .= "{ y: '" . $key . "', a: '" . $value . "' },";
			$output .= "{ y: '" . $key . "',";
			foreach ($value as $network => $single) {
				$output .= "'".$network."' : '".$single."',";
				$xKeysObject[$network] = $network;
			}
			
			$output .= "},";
	
		}
		
		$xKeyStr = "";
		$series_label = "";
		foreach ($xKeysObject as $one) {
			$xKeyStr .= "'".$one."',";
			$series_label .= "'".(isset($labelsObject[$one]) ? $labelsObject[$one] : '')."',";
		}
	
		$output .= "],
		xkey: 'y',
		ykeys: [".$xKeyStr."],
		hideHover: true,
		labels: [" . $series_label . "],
		lineWidth: '1px'
	});";
	
		$output = str_replace ( ',]', ']', $output );
		$output = str_replace ( ',}', '}', $output );
		
		return $output;
	}
	
	public static function keyObjectToMorrisLineGraph($chart_id, $object, $series_label = 'Total Value:') {
		$output = "";
		
		$output .= "Morris.Line({
  element: '" . $chart_id . "',
  data: [";
		
		$is_passedOne = false;
		foreach ( $object as $key => $value ) {
			if ($value == 0 && !$is_passedOne) {
				$is_passedOne = true;
				continue;
			}
			$is_passedOne = true;
			
			$output .= "{ y: '" . $key . "', a: '" . $value . "' },";
						
		}
		
		$output .= "],
  xkey: 'y',
  ykeys: ['a'],
  hideHover: true,
  labels: ['" . $series_label . "'],
  lineColors: ['#3498db']
});";
		
		$output = str_replace ( ',]', ']', $output );
		
		return $output;
	}
	
	public static function aggregateTotalFromObject($queue_data) {
		$total = 0;
		
		foreach ( $queue_data as $network => $data ) {
			$single = isset ( $data ['count'] ) ? $data ['count'] : 0;
			$single = intval ( $single );
			
			$total += $single;
		}
		
		return $total;
	}
	
	public static function keyObjectToMorrisAreaGraph($chart_id, $object, $series_label = 'Total Value:') {
		$output = "";
		
		$output .= "Morris.Area({
		element: '" . $chart_id . "',
		data: [";
		
		foreach ( $object as $key => $value ) {
			$output .= "{ y: '" . $key . "', a: '" . $value . "' },";
		}
		
		$output .= "],
		xkey: 'y',
		ykeys: ['a'],
		labels: ['" . $series_label . "'],
		hideHover: true,
		lineColors: ['#3498db']
	});";
		
		$output = str_replace ( ',]', ']', $output );
		
		return $output;
	}
	
	public static function keyNetworkObjectToBarGraph($chart_id, $object, $label = 'Changes for the period:') {
		$output = "";
		
		$output .= "Morris.Bar({
		element: '" . $chart_id . "',
		data: [";
		
		foreach ( $object as $key => $value ) {
			if (intval ( $value ['diff_value'] ) == 0) {
				continue;
			}
			$output .= "{ y: '" . $value ['name'] . "', a: '" . $value ['diff_value'] . "' },";
		}
		
		$output .= "],
		xkey: 'y',
		ykeys: ['a'],
		labels: ['".$label."'],
		gridTextSize: '11',
		barRatio: 0.4,
		xLabelAngle: 35,
		grid: true,
		hideHover: true,
		barColors: ['#3498db']
		});";
		
		$output = str_replace ( ',]', ']', $output );
		
		return $output;
	}
	
	public static function timeago($time) {
		$periods = array ("second", "minute", "hour", "day", "week", "month", "year", "decade" );
		$lengths = array ("60", "60", "24", "7", "4.35", "12", "10" );
		
		$now = time ();
		
		$difference = $now - $time;
		$tense = "ago";
		
		for($j = 0; $difference >= $lengths [$j] && $j < count ( $lengths ) - 1; $j ++) {
			$difference /= $lengths [$j];
		}
		
		$difference = round ( $difference );
		
		if ($difference != 1) {
			$periods [$j] .= "s";
		}
		
		return "$difference $periods[$j] ago";
	}
	
	public static function generateDetailedPeriodReport($fromDate, $toDate, $object) {
		$datesContainer = array ();
		
		$options = EasySocialMetricsPro_Options::get_instance ();
		$active_networks = $options->get_options_key ( 'active_networks' );
		
		$workDate = $fromDate;
		while ( $workDate <= $toDate ) {
			$datesContainer [$workDate] = array ('value' => 0, 'diff_value' => 0, 'networks' => array () );
			
			foreach ( $active_networks as $network ) {
				$datesContainer [$workDate] ['networks'] [$network] = array ('value' => 0, 'diff_value' => 0 );
			}
			
			$workDate = date ( 'Y-m-d', strtotime ( $workDate . ' +1 day' ) );
		
		}
		
		foreach ( $object as $single ) {
			$date = $single->esmp_date;
			
			$serialized_data = $single->esmp_data;
			
			$date_data = unserialize ( $serialized_data );
			
			$total = EasySocialMetricsPro_ReportHelper::aggregateTotalFromObject($date_data);
			$datesContainer[$date]['value'] += $total;
			
			foreach ( $date_data as $network => $data ) {
				$single = isset ( $data ['count'] ) ? $data ['count'] : 0;
				$single = intval ( $single );
				
				if (in_array($network, $active_networks)) {
					$datesContainer[$date]['networks'][$network]['value'] += $single;
				}
			}
		}
		
		$previous_value = -1;
		$network_previous_values = array();
		
		foreach ($datesContainer as $key => $data) {
			
			$current = $data['value'];
			
			if ($previous_value == -1) {
				$previous_value = $current;
			}
			else {
				$diff = $current - $previous_value;
				$datesContainer[$key]['diff_value'] = $diff;
				$previous_value = $current;
			}
			
			$networks = $data['networks'];
			foreach ($networks as $oneNetwork => $oneNetworkData) {
				$current = $oneNetworkData['value'];
				
				if (!isset($network_previous_values[$oneNetwork])) {
					$network_previous_values[$oneNetwork] = $current;
				}
				else {
					$previous_network_value = $network_previous_values[$oneNetwork];
					$diff = $current - $previous_network_value;
					$datesContainer[$key]['networks'][$oneNetwork]['diff_value'] = $diff;
					$network_previous_values[$oneNetwork] = $current;
				}
			}
			
		}
		
		return $datesContainer;
	}
}

function uSortByDiffValue($a, $b) {
	$x = isset ( $a ['diff_value'] ) ? $a ['diff_value'] : 0;
	$y = isset ( $b ['diff_value'] ) ? $b ['diff_value'] : 0;
	
	$x = intval ( $x );
	$y = intval ( $y );
	
	if ($x == $y) {
		return 0;
	}
	return ($y < $x) ? - 1 : 1;
}

?>