<?php

class EasySocialMetricsPro_SocialUpdater {
	
	private static $instance = null;
	
	function __constuctor() {
	
	}
	
	public static function get_instance() {
		
		if (null == self::$instance) {
			self::$instance = new self ();
		}
		
		return self::$instance;
	
	} // end get_instance;
	
	public function update_all($url, $blog_id, $post_id) {
	
		$esmp_options = EasySocialMetricsPro_Options::get_instance();
		$networks = $esmp_options->get_options_key('active_networks');
		
		// testing data generation
		//$test_network_list = array("http://www.facebook.com", "http://www.google.com", "http://www.pinterest.com", "http://www.linkedin.com", "http://www.cnn.com", "http://www.mashable.com", "http://wwww.vk.com", "http://www.managewp.org", "http://www.tumblr.com");
		//$rand_id = rand(0, count($test_network_list) -1);
		
		//$url = $test_network_list[$rand_id];
		
		$updated_data = array();
		
		foreach ($networks as $one) {
			switch ($one) {
				case "facebook":
					$updated_data[$one] = $this->get_facebook($url);
					break;
				case "twitter":
					$updated_data[$one] = $this->get_tweets($url);
					break;					
				case "google":
					$updated_data[$one] = $this->get_plusones($url);
					break;					
				case "linkedin":
					$updated_data[$one] = $this->get_linkedin($url);
					break;					
				case "pinterest":
					$updated_data[$one] = $this->get_pinterest($url);
					break;					
				case "stumble":
					$updated_data[$one] = $this->get_stumble($url);
					break;					
				case "reddit":
					$updated_data[$one] = $this->get_reddit($url);
					break;					
				case "vk":
					$updated_data[$one] = $this->get_vk($url);
					break;					
				case "ok":
					$updated_data[$one] = $this->get_odnoklassniki($url);
					break;					
				case "xing":
					$updated_data[$one] = $this->get_xing($url);
					break;					
				case "managewp":
					$updated_data[$one] = $this->get_managewp($url);
					break;					
				case "buffer":
					$updated_data[$one] = $this->get_buffer($url);
					break;					
			}
		}
		
		$serialize_new = serialize($updated_data);
		$date = date("Y-m-d");
		// record in database
		EasySocialMetricsPro_DatabaseHelper::updateDateRecord($blog_id, $post_id, $date, $serialize_new);
		$total_shared_value = $this->aggregate_total($updated_data);
		// record in post meta
		update_post_meta($post_id, "esmp_last_update", time());
		update_post_meta($post_id, "esmp_data", $serialize_new);
		update_post_meta($post_id, "esmp_total", $total_shared_value);
	}
	
	public function aggregate_total($queue_data) {
		$total = 0;
		
		foreach ($queue_data as $network => $data) {
			$single = isset($data['count']) ? $data['count'] : 0;
			$single = intval($single);
			
			$total += $single;
		}
		
		return $total;
	}
	
	public function get_facebook($url) {
		$parse_url = 'https://graph.facebook.com/fql?q=SELECT%20like_count,%20total_count,%20share_count,%20click_count,%20comment_count%20FROM%20link_stat%20WHERE%20url%20=%20%22' . $url . '%22';
		$content = $this->parse ( $parse_url );
		
		$result = 0;
		$result_comments = 0;
		
		if ($content != '') {
			$content = json_decode ( $content, true );
			
			$data_parsers = $content['data'];
			$result = isset ( $data_parsers [0] ['total_count'] ) ? intval ( $data_parsers [0] ['total_count'] ) : 0;
			$result_comments = isset ( $data_parsers [0] ['comment_count'] ) ? intval ( $data_parsers [0] ['comment_count'] ) : 0;
		}
		
		return array ('count' => $result, 'comments' => $result_comments );
	}
	
	function get_tweets($url) {
		$json_string = $this->parse ( 'http://urls.api.twitter.com/1/urls/count.json?url=' . $url );
		$json = json_decode ( $json_string, true );
		$result = isset ( $json ['count'] ) ? intval ( $json ['count'] ) : 0;
		
		return array('count' => $result);
	}
	function get_linkedin($url) {
		$json_string = $this->parse( "http://www.linkedin.com/countserv/count/share?url=$url&format=json" );
		$json = json_decode ( $json_string, true );
		$result = isset ( $json ['count'] ) ? intval ( $json ['count'] ) : 0;
		return array('count' => $result);
	}

	function get_plusones($url) {
		$buttonUrl = sprintf('https://plusone.google.com/u/0/_/+1/fastbutton?url=%s', urlencode($url));
		//$htmlData  = file_get_contents($buttonUrl);
		$htmlData  = $this->parse($buttonUrl);
			
		@preg_match_all('#{c: (.*?),#si', $htmlData, $matches);
		$ret = isset($matches[1][0]) && strlen($matches[1][0]) > 0 ? trim($matches[1][0]) : 0;
		if(0 != $ret) {
			$ret = str_replace('.0', '', $ret);
		}
	
		return array('count' => $ret);
	}
	function get_pinterest($url) {
		$return_data = $this->parse ( 'http://api.pinterest.com/v1/urls/count.json?url=' . $url );
		$json_string = preg_replace ( '/^receiveCount\((.*)\)$/', "\\1", $return_data );
		$json = json_decode ( $json_string, true );
		$result = isset ( $json ['count'] ) ? intval ( $json ['count'] ) : 0;
		
		return array('count' => $result);
	}
	
	function get_stumble($url) {
		$json_string = $this->parse('http://www.stumbleupon.com/services/1.01/badge.getinfo?url='.$url);
		$json = json_decode($json_string, true);
		$result = isset($json['result']['views'])?intval($json['result']['views']):0;
		
		return array('count' => $result);
	}
	
	function get_reddit($url) {
		$reddit_url = 'http://www.reddit.com/api/info.json?url='.$url;
		$format = "json";
		$score = $ups = $downs = 0; //initialize
	
		/* action */
		$content = $this->parse( $reddit_url );
		if($content) {
			if($format == 'json') {
				$json = json_decode($content,true);
				foreach($json['data']['children'] as $child) { // we want all children for this example
					$ups+= (int) $child['data']['ups'];
					$downs+= (int) $child['data']['downs'];
					//$score+= (int) $child['data']['score']; //if you just want to grab the score directly
				}
				$score = $ups - $downs;
			}
		}
	
		return array('count' => $score);
	}
	
	function get_vk( $url ) {
		$CHECK_URL_PREFIX = 'http://vk.com/share.php?act=count&url=';
	
		$check_url = $CHECK_URL_PREFIX . $url;
	
		$data   = $this->parse( $check_url );
		$shares = array();
	
		preg_match( '/^VK\.Share\.count\(\d, (\d+)\);$/i', $data, $shares );
	
		$result = isset($shares[ 1 ]) ? $shares[1] : 0;
		
		return array('count' => $result);
	}
	
	function get_odnoklassniki( $url ) {
		$CHECK_URL_PREFIX = 'http://www.odnoklassniki.ru/dk?st.cmd=extLike&uid=odklcnt0&ref=';
	
		$check_url = $CHECK_URL_PREFIX . $url;
	
		$data   = $this->parse( $check_url );
		$shares = array();
	
		//print $check_url . ' = ' .$data;
		preg_match( '/^ODKL\.updateCount\(\'odklcnt0\',\'(\d+)\'\);$/i', $data, $shares );
	
		$result = isset($shares[1]) ? (int)$shares[ 1 ] : 0;
		
		return array('count' => $result);
	}
	
	function get_xing($url) {
		//- Get Xing Shares counter from this https://www.xing-share.com/app/share?op=get_share_button;url=https://blog.xing.com/2012/01/the-shiny-new-xing-share-button-how-to-implement-it-in-your-blog-or-website/;counter=top;lang=en;type=iframe;hovercard_position=2;shape=rectangle
		$buttonURL = sprintf('https://www.xing-share.com/app/share?op=get_share_button;url=%s;counter=top;lang=en;type=iframe;hovercard_position=2;shape=rectangle', urlencode($url));
		$data  = $this->parse($buttonURL);
		$shares = array();
	
		$count = 0;
		preg_match( '/<span class="xing-count top">(.*?)<\/span>/s', $data, $shares );
	
		if (count($shares) > 0) {
			$current_result = $shares[1];
	
			$count = $current_result;
		}
	
		return array('count' => $count);
	}
	
	function get_managewp($url) {
		$buttonURL = sprintf('https://managewp.org/share/frame/small?url=%s', urlencode($url));
		$data  = $this->parse($buttonURL);
		$shares = array();
	
		$count = 0;
		preg_match( '/<form(.*?)<\/form>/s', $data, $shares );
	
		if (count($shares) > 0) {
			$current_result = $shares[1];
				
			$second_parse = array();
			preg_match( '/<div>(.*?)<\/div>/s', $current_result, $second_parse );
				
			$value = $second_parse[1];
			$value = str_replace("<span>", "", $value);
			$value = str_replace("</span>", "", $value);
				
			$count = $value;
		}
	
		return array('count' => $count);
	}
	
	function get_buffer($url) {
		//&callback=data
		$content = $this->parse('https://api.bufferapp.com/1/links/shares.json?url='.$url.'');
		$result = 0;
		if ($content != '') {
			$json = json_decode($content,true);
			$result = isset($json['shares']) ? $json['shares'] : 0;
		}
		
		return array('count' => $result);
	}
	
	function parse($encUrl) {
		
		$options = array (CURLOPT_RETURNTRANSFER => true, 		// return web page
		CURLOPT_HEADER => false, 		// don't return headers
		                            // CURLOPT_FOLLOWLOCATION => true, // follow
		                            // redirects
		CURLOPT_ENCODING => "", 		// handle all encodings
		CURLOPT_USERAGENT => 'EasySocialMetricsPro', 		// who am i
		CURLOPT_AUTOREFERER => true, 		// set referer on redirect
		CURLOPT_CONNECTTIMEOUT => 5, 		// timeout on connect
		CURLOPT_TIMEOUT => 10, 		// timeout on response
		CURLOPT_MAXREDIRS => 3, 		// stop after 3 redirects
		CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => false );
		$ch = curl_init ();
		
		if (ini_get ( 'open_basedir' ) == '' && ini_get ( 'safe_mode' == 'Off' )) {
			$options [CURLOPT_FOLLOWLOCATION] = true;
		}
		
		$options [CURLOPT_URL] = $encUrl;
		curl_setopt_array ( $ch, $options );
		// force ip v4 - uncomment this
		try {
			curl_setopt ( $ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
		} catch ( Exception $e ) {
		
		}
		
		$content = curl_exec ( $ch );
		$err = curl_errno ( $ch );
		$errmsg = curl_error ( $ch );
		
		curl_close ( $ch );
		
		return $content;
	}
}

?>