<?php

class EasySocialMetricsPro_DummyDataGenerator {
	
	public $esmp_options = array ();
	public $generated_data = array ();
	
	function __construct() {
		$this->esmp_options = EasySocialMetricsPro_Options::get_instance ();
	}
	
	public function generate($fromDate, $toDate) {
		
		global $blog_id;
		
		$networks = $this->esmp_options->get_options_key ( 'active_networks' );
		
		$post_types = $this->esmp_options->get_monitored_post_types ();
		
		$workDate = $fromDate;
		
		while ( $workDate <= $toDate ) {
			
			$querydata = query_posts ( array ('order' => 'DESC', 'orderby' => 'post_date', 'posts_per_page' => - 1, 'post_status' => 'publish', 'post_type' => $post_types ) );
			
			foreach ( $querydata as $querydatum ) {
				$post_id = $querydatum->ID;
				
				$singleDayData = array();
				
				if (!isset($this->generated_data[$post_id])) {
					$this->generated_data[$post_id] = array();
				}
				else {
					$singleDayData = $this->generated_data[$post_id];
				}
			
				foreach ($networks as $oneNetwork) {
					$current_value = 0;
					if (isset($singleDayData[$oneNetwork])) {
						$current_value = $singleDayData[$oneNetwork]['count'];
					}
					else {
						$singleDayData[$oneNetwork] = array('count' => 0);
					}
					
					$increase = $rand_id = rand(0, 50);
					$current_value += $increase;
					
					$singleDayData[$oneNetwork]['count'] = $current_value;
					
				}
				
				$this->generated_data[$post_id] = $singleDayData;
				
				
				$serialize_new = serialize($singleDayData);
				$date = date("Y-m-d");
				// record in database
				EasySocialMetricsPro_DatabaseHelper::updateDateRecord($blog_id, $post_id, $workDate, $serialize_new);
				$total_shared_value = $this->aggregate_total($singleDayData);
				// record in post meta
				update_post_meta($post_id, "esmp_last_update", time());
				update_post_meta($post_id, "esmp_data", $serialize_new);
				update_post_meta($post_id, "esmp_total", $total_shared_value);
			}
			$workDate = date ( 'Y-m-d', strtotime ( $workDate . ' +1 day' ) );
		}
	}

	public function aggregate_total($queue_data) {
		$total = 0;
	
		foreach ($queue_data as $network => $data) {
			$single = isset($data['count']) ? $data['count'] : 0;
			$single = intval($single);
				
			$total += $single;
		}
	
		return $total;
	}
}

?>