<?php

$options = EasySocialMetricsPro_Options::get_instance ();
$network_list = $options->get_options_key ( 'networks' );
$active_networks = $options->get_options_key ( 'active_networks' );


$esmp_date_from = isset ( $_REQUEST ['esmp_date_from'] ) ? $_REQUEST ['esmp_date_from'] : '';
$esmp_date_to = isset ( $_REQUEST ['esmp_date_to'] ) ? $_REQUEST ['esmp_date_to'] : '';

if ($esmp_date_to == '') {
	$esmp_date_to = date ( "Y-m-d" );
}

if ($esmp_date_from == '') {
	$esmp_date_from = date ( "Y-m-d", strtotime ( date ( "Y-m-d", strtotime ( date ( "Y-m-d" ) ) ) . "-1 month" ) );
}

$date_range_data = EasySocialMetricsPro_DatabaseHelper::getDateRangeRecords ( $esmp_date_from, $esmp_date_to );
$date_range_object = EasySocialMetricsPro_ReportHelper::sqlDateRangeRecordConvert ( $esmp_date_from, $esmp_date_to, $date_range_data );
$date_changes_object = EasySocialMetricsPro_ReportHelper::sqlCreateChangesInObject ( $esmp_date_from, $esmp_date_to, $date_range_data );

$network_object = EasySocialMetricsPro_ReportHelper::sqlCreateNetworkChangesValues ( $date_range_data );

$post_object = EasySocialMetricsPro_ReportHelper::sqlCreatePostChangesValue ( $date_range_data );

 //print_r($post_object);

?>

<div class="esmp-dashboard">
	<div class="esmp-dashboard-chart">
		<div class="esmp-dashboard-chart-range">
			<div class="esmp-dashbarod-chart-range-period">
				<form method="POST">
					Date range: <input name="esmp_date_from"
						value="<?php echo $esmp_date_from;?>" id="esmp_date_from"
						class="input-element" /> <input name="esmp_date_to"
						value="<?php echo $esmp_date_to;?>" id="esmp_date_to"
						class="input-element" /> <input type="submit" value="Apply"
						class="button" />
				</form>
			</div>
		</div>
	</div>
	<div class="esmp-dashboard-panel">
		<div class="esmp-dashboard-panel-title">
			<h4>Social Shares Dynamic for the period</h4>
		</div>
		<div class="esmp-dashboard-chart-range-graph"
			id="esmp-dashboard-chart-range-graph"></div>

	</div>

	<br class="clear"/>

	<div class="row">

		<div class="twocols right">
			<div class="esmp-dashboard-panel">
				<div class="esmp-dashboard-panel-title">
					<h4>Social shares for a date</h4>
				</div>

				<div class="esmp-changes-graph" id="esmp-changes-graph"></div>

			</div>
		</div>
		<div class="twocols left">
			<div class="esmp-dashboard-panel">
				<div class="esmp-dashboard-panel-title">
					<h4>Social network values for the period</h4>
				</div>

				<div class="esmp-networks-graph" id="esmp-networks-graph"></div>

			</div>
		</div>
	</div>

<br class="clear"/>
	<div class="row">
		<div class="esmp-dashboard-panel">
			<div class="esmp-dashboard-panel-title">
				<h4>Top 20 social posts for the period</h4>
			</div>

			<div class="esmp-top-posts" id="esmp-top-posts">
			
				<table border="0" cellpadding="4" cellspacing="0" width="100%">
				
				<thead>
					<tr>
						<th>Post</th>
						<th>Total Score</th>

					<?php 
					foreach ( $network_list as $key => $name ) {
							
						if (in_array ( $key, $active_networks )) {
							echo '<th>'.$name.'</th>';
						}
					}
					
					?>	
					</tr>
				
				</thead>		
				<tbody>
				
				<?php 
				$cnt = 0;
				foreach ($post_object as $key => $data) {
					if ($cnt >= 20) { break; }
					
					$post_id = $data['post_id'];
					
					$post = get_post($post_id);
					if (!isset($post)) { continue; }
					$post_permalink = get_permalink($post_id);
					$post_title = $post->post_title;
					
					$css_class = ($cnt % 2 == 0) ? "even" : "odd";
					
					echo '<tr class="'.$css_class.'">';
					
					echo '<td><a href="'.$post_permalink.'" target="_blank">'.$post_title.'</a></td>';
					echo '<td class="dashboard-table-value total-value">'.number_format($data['diff_value']).'</td>';
						
					foreach ( $network_list as $key => $name ) {
							
						if (in_array ( $key, $active_networks )) {
							$network_value = $data[$key]['diff_value'];
							echo '<td class="dashboard-table-value">'.number_format($network_value).'</td>';
						}
					}
					
					echo '</tr>';
					
					$cnt++;
				}
				
				?>
				
				</tbody>		
				</table>
			
			</div>

		</div>
	</div>
</div>
<script type="text/javascript">
jQuery(document).ready(function($){
      //$( "#esmp_date_from" ).datepicker( );
	var pickerFrom = new Pikaday({ field: $('#esmp_date_from')[0], format: "YYYY-MM-DD" });
	var pickerTo = new Pikaday({ field: $('#esmp_date_to')[0], format: "YYYY-MM-DD" });
     // $( "#esmp_date_to" ).datepicker(  {"dateFormat": "yy-mm-dd"} );

      <?php
						echo EasySocialMetricsPro_ReportHelper::keyObjectToMorrisAreaGraph ( 'esmp-dashboard-chart-range-graph', $date_range_object, 'Total social score for monitored content and networks' );
						echo EasySocialMetricsPro_ReportHelper::keyObjectToMorrisLineGraph ( 'esmp-changes-graph', $date_changes_object, 'Social shares for this date' );
						echo EasySocialMetricsPro_ReportHelper::keyNetworkObjectToBarGraph ( 'esmp-networks-graph', $network_object, 'Social shares for the period' );
						?>
});
	
</script>