<?php

$mode = isset ( $_REQUEST ['mode'] ) ? $_REQUEST ['mode'] : '';

$options = EasySocialMetricsPro_Options::get_instance ();
$network_list = $options->get_options_key ( 'networks' );
$active_networks = $options->get_options_key ( 'active_networks' );

$esmp_date_from = isset ( $_REQUEST ['esmp_date_from'] ) ? $_REQUEST ['esmp_date_from'] : '';
$esmp_date_to = isset ( $_REQUEST ['esmp_date_to'] ) ? $_REQUEST ['esmp_date_to'] : '';

if ($esmp_date_to == '') {
	$esmp_date_to = date ( "Y-m-d" );
}

if ($esmp_date_from == '') {
	$esmp_date_from = date ( "Y-m-d", strtotime ( date ( "Y-m-d", strtotime ( date ( "Y-m-d" ) ) ) . "-14 days" ) );
}

if ($mode != 'date') {
	$date_range_data = EasySocialMetricsPro_DatabaseHelper::getDateRangeRecords ( $esmp_date_from, $esmp_date_to );
	$data_object = EasySocialMetricsPro_ReportHelper::generateDetailedPeriodReport ( $esmp_date_from, $esmp_date_to, $date_range_data );
	$data_object = array_reverse ($data_object);
	$chart_object = array();
	
	// Generate best values
	$chart_legend_objects = array();
	$chart_legend_objects['all'] = 'Total';
	foreach ( $data_object as $key => $data ) {
		$diff_value = $data ['diff_value'];
	
		if ($diff_value == 0) {
			continue;
		}
		//$chart_object[$key] = array();
		//$chart_object[$key]['diff_value'] = $diff_value;
		//$chart_object[$key]['name'] = $key;
		$chart_object[$key] = array();		
		$chart_object[$key]['all'] = $diff_value;
		
		foreach ( $network_list as $network => $name ) {
				
			if (in_array ( $network, $active_networks )) {
		
				$network_diff_value = $data ['networks'] [$network] ['diff_value'];
				$network_diff_value_class = "";
				
				$chart_object[$key][$network] = $network_diff_value;
				$chart_legend_objects[$network] = $name;
			}
		}
	}
	
	?>

<div class="esmp-dashboard">
	<div class="esmp-dashboard-chart">
		<div class="esmp-dashboard-chart-range">
			<div class="esmp-dashbarod-chart-range-period"
				style="text-align: left;">
				<form method="POST">
					Date range: <input name="esmp_date_from"
						value="<?php echo $esmp_date_from;?>" id="esmp_date_from"
						class="input-element" /> <input name="esmp_date_to"
						value="<?php echo $esmp_date_to;?>" id="esmp_date_to"
						class="input-element" /> <input type="submit" value="Apply"
						class="button" />
				</form>
			
			</div>
		</div>
	</div>

	<br class="clear" />
	
	<div class="row">
		<div class="esmp-dashboard-panel">
			<div class="esmp-dashboard-panel-title">
				<h4>Social Shares Dynamic</h4>
			</div>
			
			<div class="esmp-date-chart" id="esmp-date-chart"></div>
		</div>
	</div>
	
	<br class="clear" />

	<div class="row">
		<div class="esmp-dashboard-panel">
			<div class="esmp-dashboard-panel-title" style="height: 20px;">
				<h4 style="float:left;">Detailed social report for period</h4><div style="float: right;"><span class="best-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Best value for the period</span> &nbsp;<span
					class="worst-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Worst value for the period</span></div>
			</div>

			<div class="esmp-top-posts" id="esmp-top-posts">

				<table border="0" cellpadding="4" cellspacing="0" width="100%" class="report-table">

					<thead>
						<tr>
							<th>Date <br/><small>Click on date to view detailed post information</small></th>
							<th>Total Social Score</th>

					<?php
	foreach ( $network_list as $key => $name ) {
		
		if (in_array ( $key, $active_networks )) {
			echo '<th>' . $name . '</th>';
		}
	}
	
	?>	
					</tr>

					</thead>
					<tbody>
				
				<?php
	$cnt = 0;
	
	$best_values = array ();
	$worst_values = array ();
	
	//$chart_object = array();
	
	// Generate best values
	foreach ( $data_object as $key => $data ) {
		$diff_value = $data ['diff_value'];
		
		if ($diff_value == 0) {
			continue;
		}
		
		//$chart_object[$key] = $diff_value;
		
		if (! isset ( $best_values ['all'] )) {
			$best_values ['all'] = $diff_value;
		} else {
			$current_best_value = $best_values ['all'];
			if ($diff_value > $current_best_value) {
				$best_values ['all'] = $diff_value;
			}
		}
		
		if (! isset ( $worst_values ['all'] )) {
			$worst_values ['all'] = $diff_value;
		} else {
			$current_worst_value = $worst_values ['all'];
			if ($current_worst_value > $diff_value) {
				$worst_values ['all'] = $diff_value;
			}
		}
		
		foreach ( $network_list as $network => $name ) {
			
			if (in_array ( $network, $active_networks )) {
				$network_value = $data ['networks'] [$network] ['diff_value'];
				
				if ($network_value == 0) {
					continue;
				}
				
				if (! isset ( $best_values [$network] )) {
					$best_values [$network] = $network_value;
				} else {
					$current_best_value = $best_values [$network];
					if ($network_value > $current_best_value) {
						$best_values [$network] = $network_value;
					}
				}
				
				if (! isset ( $worst_values [$network] )) {
					$worst_values [$network] = $network_value;
				} else {
					$current_worst_value = $worst_values [$network];
					if ($current_worst_value > $network_value) {
						$worst_values [$network] = $network_value;
					}
				}
			}
		}
	}
	
	// output data
	
	foreach ( $data_object as $key => $data ) {
		
		$css_class = ($cnt % 2 == 0) ? "even" : "odd";
		
		echo '<tr class="' . $css_class . '">';
		
		$diff_value = $data ['diff_value'];
		$diff_value_class = "";
		
		$cell_color_class = "";
		$overall_best = isset($best_values ['all']) ? $best_values ['all'] : 0;
		$overall_worst = isset($worst_values ['all']) ? $worst_values ['all'] : 0;
		
		if ($diff_value == $overall_best) {
			$cell_color_class = "best-value";
		}
		if ($diff_value == $overall_worst) {
			$cell_color_class = "worst-value";
		}
		
		if (intval ( $diff_value ) > 0) {
			$diff_value = "+" . $diff_value;
			$diff_value_class = "up-value";
		} else if (intval ( $diff_value ) < 0) {
			$diff_value_class = "down-value";
		} else {
			$diff_value_class = "hidden-value";
		}
		
		echo '<td><a href="admin.php?page=easy-social-metrics-pro&tab=detailed&mode=date&date=' . $key . '&esmp_date_from=' . $esmp_date_from . '&esmp_date_to=' . $esmp_date_to . '">' . $key . '</a></td>';
		echo '<td class="dashboard-table-value total-value ' . $cell_color_class . '">' . number_format ( $data ['value'] ) . ' <span class="diff-value ' . $diff_value_class . '">( ' . $diff_value . ' )</span></td>';
		
		foreach ( $network_list as $network => $name ) {
			
			if (in_array ( $network, $active_networks )) {
				$network_value = $data ['networks'] [$network] ['value'];
				
				$network_diff_value = $data ['networks'] [$network] ['diff_value'];
				$network_diff_value_class = "";
				
				$cell_color_class = "";
				$overall_best = isset($best_values [$network]) ? $best_values [$network] : 0;
				$overall_worst = isset($worst_values [$network]) ? $worst_values [$network] : 0;
				
				if ($network_diff_value == $overall_best) {
					$cell_color_class = "best-value";
				}
				if ($network_diff_value == $overall_worst) {
					$cell_color_class = "worst-value";
				}
				
				if (intval ( $network_diff_value ) > 0) {
					$network_diff_value = "+" . $network_diff_value;
					$network_diff_value_class = "up-value";
				} else if (intval ( $network_diff_value ) < 0) {
					$network_diff_value_class = "down-value";
				} else {
					$network_diff_value_class = "hidden-value";
				}
				
				echo '<td class="dashboard-table-value ' . $cell_color_class . '">' . number_format ( $network_value ) . ' <span class="diff-value ' . $network_diff_value_class . '">( ' . $network_diff_value . ' )</span></td>';
			}
		}
		
		echo '</tr>';
		
		$cnt ++;
	}
	
	?>
				
				</tbody>
				</table>

			</div>

		</div>
	</div>
</div>
<script type="text/javascript">
jQuery(document).ready(function($){
      //$( "#esmp_date_from" ).datepicker( );
	var pickerFrom = new Pikaday({ field: $('#esmp_date_from')[0], format: "YYYY-MM-DD" });
	var pickerTo = new Pikaday({ field: $('#esmp_date_to')[0], format: "YYYY-MM-DD" });

	<?php 
	echo EasySocialMetricsPro_ReportHelper::keyObjectToMorrisLineGraphMulti ( 'esmp-date-chart', $chart_object, $chart_legend_objects );
	//echo EasySocialMetricsPro_ReportHelper::keyNetworkObjectToBarGraph ( 'esmp-date-chart', $chart_object, 'Social Shares' );
	?>
  
});
	
</script>

<?php } else { ?>

<?php
	
	$request_date = isset ( $_REQUEST ['date'] ) ? $_REQUEST ['date'] : '';
	$prev_date = date ( 'Y-m-d', strtotime ( $request_date . ' -1 day' ) );
	$date_range_data = EasySocialMetricsPro_DatabaseHelper::getDateRangeRecords ( $prev_date, $request_date );
	
	$post_object = EasySocialMetricsPro_ReportHelper::sqlCreatePostChangesValue ( $date_range_data );
	// echo '<pre>';
	// var_dump($post_object);
	// echo '</pre>';
	?>

<div class="esmp-dashboard">
	<div class="esmp-dashboard-chart">
		<div class="esmp-dashboard-chart-range">
			<div class="esmp-dashbarod-chart-range-period"
				style="text-align: left;">
				<a
					href="admin.php?page=easy-social-metrics-pro&tab=detailed&esmp_date_from=<?php echo $esmp_date_from; ?>&esmp_date_to=<?php echo $esmp_date_to; ?>"
					class="button">< Back</a> <br />
				<br /> <span class="best-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Best value for the period</span> &nbsp;<span
					class="worst-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Worst value for the period</span>
			</div>
		</div>
	</div>

	<br class="clear" />
	<div class="row">
		<div class="esmp-dashboard-panel">
			<div class="esmp-dashboard-panel-title">
				<h4>Detailed Social Report for <?php echo $request_date; ?></h4>
			</div>

			<div class="esmp-top-posts" id="esmp-top-posts">

				<table border="0" cellpadding="4" cellspacing="0" width="100%" class="report-table">

					<thead>
						<tr>
							<th>Post</th>
							<th>Total Score</th>

					<?php
	foreach ( $network_list as $key => $name ) {
		
		if (in_array ( $key, $active_networks )) {
			echo '<th>' . $name . '</th>';
		}
	}
	
	?>	
					</tr>

					</thead>
					<tbody>
				
				<?php
	$cnt = 0;
	$total = array ();
	
	$best_values = array ();
	$worst_values = array ();
	
	foreach ( $post_object as $key => $data ) {
		$diff_value = $data ['diff_value'];
		
		if (! isset ( $best_values ['all'] )) {
			$best_values ['all'] = $diff_value;
		} else {
			$current_value = $best_values ['all'];
			if ($current_value < $diff_value) {
				$best_values ['all'] = $diff_value;
			}
		}
		
		if (! isset ( $worst_values ['all'] )) {
			$worst_values ['all'] = $diff_value;
		} else {
			$current_value = $worst_values ['all'];
			if ($current_value > $diff_value) {
				$worst_values ['all'] = $diff_value;
			}
		}
		
		foreach ( $network_list as $key => $name ) {
			
			if (in_array ( $key, $active_networks )) {
				$network_value = $data [$key] ['diff_value'];
				
				if (! isset ( $best_values [$key] )) {
					$best_values [$key] = $network_value;
				} else {
					$current_value = $best_values [$key];
					if ($current_value < $network_value) {
						$best_values [$key] = $network_value;
					}
				}
				
				if (! isset ( $worst_values [$key] )) {
					$worst_values [$key] = $network_value;
				} else {
					$current_value = $worst_values [$key];
					if ($current_value > $network_value) {
						$worst_values [$key] = $network_value;
					}
				}
			}
		}
	}
	
	foreach ( $post_object as $key => $data ) {
		
		$post_id = $data ['post_id'];
		
		$post = get_post ( $post_id );
		if (! isset ( $post )) {
			continue;
		}
		$post_permalink = get_permalink ( $post_id );
		$post_title = $post->post_title;
		
		$diff_value = $data ['diff_value'];
		$color_css_class = "";
		$overall_best = isset($best_values ['all']) ? $best_values ['all'] : 0;
		$overall_worst = isset($worst_values ['all']) ? $worst_values ['all'] : 0;
		
		if ($overall_best == $diff_value) {
			$color_css_class = "best-value";
		}
		if ($overall_worst == $diff_value) {
			$color_css_class = "worst-value";
		}
		
		$css_class = ($cnt % 2 == 0) ? "even" : "odd";
		
		echo '<tr class="' . $css_class . '">';
		
		echo '<td><a href="' . $post_permalink . '" target="_blank">' . $post_title . '</a></td>';
		echo '<td class="dashboard-table-value total-value ' . $color_css_class . '">' . number_format ( $data ['diff_value'] ) . '</td>';
		
		if (! isset ( $total ['all'] )) {
			$total ['all'] = 0;
		}
		$total ['all'] += $data ['diff_value'];
		
		foreach ( $network_list as $key => $name ) {
			
			if (in_array ( $key, $active_networks )) {
				$network_value = $data [$key] ['diff_value'];
				
				$color_css_class = "";
				$overall_best = isset($best_values [$key]) ? $best_values [$key] : 0;
				$overall_worst = isset($worst_values [$key]) ? $worst_values [$key] : 0;
				
				if ($overall_best == $network_value) {
					$color_css_class = "best-value";
				}
				if ($overall_worst == $network_value) {
					$color_css_class = "worst-value";
				}
				
				echo '<td class="dashboard-table-value '.$color_css_class.'">' . number_format ( $network_value ) . '</td>';
				
				if (! isset ( $total [$key] )) {
					$total [$key] = 0;
				}
				$total [$key] += $network_value;
			}
		}
		
		echo '</tr>';
		
		$cnt ++;
	}
	
	echo '<tr class="bold">';
	echo '<td>Total:</td>';
	$all = isset($total ['all']) ? $total ['all'] : 0;
	echo '<td class="dashboard-table-value total-value">' . number_format ( $all ) . '</td>';
	
	foreach ( $network_list as $key => $name ) {
		
		if (in_array ( $key, $active_networks )) {
			$network_value = isset($total [$key]) ? $total [$key] : 0;
			echo '<td class="dashboard-table-value">' . number_format ( $network_value ) . '</td>';
		
		}
	}
	
	echo '</tr>';
	
	?>
				
				</tbody>
				</table>

			</div>

		</div>
	</div>
</div>

<?php } ?>