<?php

$post = isset ( $_REQUEST ['post'] ) ? $_REQUEST ['post'] : '';

$options = EasySocialMetricsPro_Options::get_instance ();
$network_list = $options->get_options_key ( 'networks' );
$active_networks = $options->get_options_key ( 'active_networks' );

$esmp_date_from = isset ( $_REQUEST ['esmp_date_from'] ) ? $_REQUEST ['esmp_date_from'] : '';
$esmp_date_to = isset ( $_REQUEST ['esmp_date_to'] ) ? $_REQUEST ['esmp_date_to'] : '';

if ($esmp_date_to == '') {
	$esmp_date_to = date ( "Y-m-d" );
}

if ($esmp_date_from == '') {
	$esmp_date_from = date ( "Y-m-d", strtotime ( date ( "Y-m-d", strtotime ( date ( "Y-m-d" ) ) ) . "-1 month" ) );
}

if ($post != '') {
	$postObj = get_post ( $post );
	if (! isset ( $post )) {
		continue;
	}

	$date_range_data = EasySocialMetricsPro_DatabaseHelper::getDateRangeRecords ( $esmp_date_from, $esmp_date_to, $post );
	$data_object = EasySocialMetricsPro_ReportHelper::generateDetailedPeriodReport ( $esmp_date_from, $esmp_date_to, $date_range_data );
	$data_object = array_reverse ($data_object);
	$chart_object = array();
	
	// Generate best values
	foreach ( $data_object as $key => $data ) {
		$diff_value = $data ['diff_value'];
	
		if ($diff_value == 0) {
			continue;
		}
	
		$chart_object[$key] = $diff_value;
	}	
	?>

<div class="esmp-dashboard">
	<div class="esmp-dashboard-chart">
		<div class="esmp-dashboard-chart-range">
			<div class="esmp-dashbarod-chart-range-period"
				style="text-align: left;">
				<form method="POST">
					Date range: <input name="esmp_date_from"
						value="<?php echo $esmp_date_from;?>" id="esmp_date_from"
						class="input-element" /> <input name="esmp_date_to"
						value="<?php echo $esmp_date_to;?>" id="esmp_date_to"
						class="input-element" /> <input type="submit" value="Apply"
						class="button" />
				</form>
				
			</div>
		</div>
	</div>

	<br class="clear" />
	
	<div class="row">
		<h3><?php echo $postObj->post_title; ?></h3>
	
	</div>
	<br class="clear" />
	<div class="row">
		<div class="esmp-dashboard-panel">
			<div class="esmp-dashboard-panel-title">
				<h4>Social Shares Dynamic</h4>
			</div>
			
			<div class="esmp-date-chart" id="esmp-date-chart"></div>
		</div>
	</div>
	
	<br class="clear" />

	<div class="row">
		<div class="esmp-dashboard-panel">

			<div class="esmp-dashboard-panel-title" style="height: 20px;">
				<h4 style="float:left;">Detailed social report for <?php echo $postObj->post_title; ?></h4><div style="float: right;"><span class="best-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Best value for the period</span> &nbsp;<span
					class="worst-value"
					style="width: 30px; height: 20px; min-width: 30px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>&nbsp;<span
					class="info-label">Worst value for the period</span></div>
			</div>
			

			<div class="esmp-top-posts" id="esmp-top-posts">

				<table border="0" cellpadding="4" cellspacing="0" width="100%" class="report-table">

					<thead>
						<tr>
							<th>Date</th>
							<th>Total Social Score</th>

					<?php
	foreach ( $network_list as $key => $name ) {
		
		if (in_array ( $key, $active_networks )) {
			echo '<th>' . $name . '</th>';
		}
	}
	
	?>	
					</tr>

					</thead>
					<tbody>
				
				<?php
	$cnt = 0;
	
	$best_values = array ();
	$worst_values = array ();
	
	// Generate best values
	foreach ( $data_object as $key => $data ) {
		$diff_value = $data ['diff_value'];
		
		if ($diff_value == 0) {
			continue;
		}
		
		if (! isset ( $best_values ['all'] )) {
			$best_values ['all'] = $diff_value;
		} else {
			$current_best_value = $best_values ['all'];
			if ($diff_value > $current_best_value) {
				$best_values ['all'] = $diff_value;
			}
		}
		
		if (! isset ( $worst_values ['all'] )) {
			$worst_values ['all'] = $diff_value;
		} else {
			$current_worst_value = $worst_values ['all'];
			if ($current_worst_value > $diff_value) {
				$worst_values ['all'] = $diff_value;
			}
		}
		
		foreach ( $network_list as $network => $name ) {
			
			if (in_array ( $network, $active_networks )) {
				$network_value = $data ['networks'] [$network] ['diff_value'];
				
				if ($network_value == 0) {
					continue;
				}
				
				if (! isset ( $best_values [$network] )) {
					$best_values [$network] = $network_value;
				} else {
					$current_best_value = $best_values [$network];
					if ($network_value > $current_best_value) {
						$best_values [$network] = $network_value;
					}
				}
				
				if (! isset ( $worst_values [$network] )) {
					$worst_values [$network] = $network_value;
				} else {
					$current_worst_value = $worst_values [$network];
					if ($current_worst_value > $network_value) {
						$worst_values [$network] = $network_value;
					}
				}
			}
		}
	}
	
	// output data
	
	foreach ( $data_object as $key => $data ) {
		
		$css_class = ($cnt % 2 == 0) ? "even" : "odd";
		
		echo '<tr class="' . $css_class . '">';
		
		$diff_value = $data ['diff_value'];
		$diff_value_class = "";
		
		$cell_color_class = "";
		$overall_best = isset($best_values ['all']) ? $best_values ['all'] : 0;
		$overall_worst = isset($worst_values ['all']) ? $worst_values ['all'] : 0;
		
		if ($diff_value == $overall_best) {
			$cell_color_class = "best-value";
		}
		if ($diff_value == $overall_worst) {
			$cell_color_class = "worst-value";
		}
		
		if ($overall_worst == $overall_best) { $cell_color_class = ""; }
		
		if (intval ( $diff_value ) > 0) {
			$diff_value = "+" . $diff_value;
			$diff_value_class = "up-value";
		} else if (intval ( $diff_value ) < 0) {
			$diff_value_class = "down-value";
		} else {
			$diff_value_class = "hidden-value";
		}
		
		echo '<td><a href="admin.php?page=easy-social-metrics-pro&tab=detailed&mode=date&date=' . $key . '&esmp_date_from=' . $esmp_date_from . '&esmp_date_to=' . $esmp_date_to . '">' . $key . '</a></td>';
		echo '<td class="dashboard-table-value total-value ' . $cell_color_class . '">' . number_format ( $data ['value'] ) . ' <span class="diff-value ' . $diff_value_class . '">( ' . $diff_value . ' )</span></td>';
		
		foreach ( $network_list as $network => $name ) {
			
			if (in_array ( $network, $active_networks )) {
				$network_value = $data ['networks'] [$network] ['value'];
				
				$network_diff_value = $data ['networks'] [$network] ['diff_value'];
				$network_diff_value_class = "";
				
				$cell_color_class = "";
				$overall_best = isset($best_values [$network]) ? $best_values[$network] : 0;
				$overall_worst = isset($worst_values [$network]) ? $worst_values [$network] : 0;
				
				if ($network_diff_value == $overall_best) {
					$cell_color_class = "best-value";
				}
				if ($network_diff_value == $overall_worst) {
					$cell_color_class = "worst-value";
				}
				if ($overall_worst == $overall_best) {
					$cell_color_class = "";
				}
				
				
				if (intval ( $network_diff_value ) > 0) {
					$network_diff_value = "+" . $network_diff_value;
					$network_diff_value_class = "up-value";
				} else if (intval ( $network_diff_value ) < 0) {
					$network_diff_value_class = "down-value";
				} else {
					$network_diff_value_class = "hidden-value";
				}
				
				echo '<td class="dashboard-table-value ' . $cell_color_class . '">' . number_format ( $network_value ) . ' <span class="diff-value ' . $network_diff_value_class . '">( ' . $network_diff_value . ' )</span></td>';
			}
		}
		
		echo '</tr>';
		
		$cnt ++;
	}
	
	?>
				
				</tbody>
				</table>

			</div>

		</div>
	</div>
</div>
<script type="text/javascript">
jQuery(document).ready(function($){
      //$( "#esmp_date_from" ).datepicker( );
	var pickerFrom = new Pikaday({ field: $('#esmp_date_from')[0], format: "YYYY-MM-DD" });
	var pickerTo = new Pikaday({ field: $('#esmp_date_to')[0], format: "YYYY-MM-DD" });
	<?php 
			echo EasySocialMetricsPro_ReportHelper::keyObjectToMorrisLineGraph ( 'esmp-date-chart', $chart_object, 'Social Shares' );
			?>
});
	
</script>
<?php } else { ?>
<div class="esmp-dashboard">
	<div class="esmp-dashboard-chart">
		<div class="esmp-dashboard-chart-range">
			<div class="esmp-dashbarod-chart-range-period"
				style="text-align: left;">
<h4><a href="admin.php?page=easy-social-metrics-pro&tab=content" class="button">Click here to start full content report</a><br/><br/>
To activate detailed content report press the post title in Full Content Report table. </h4>
</div></div></div></div>
<?php }?>