<?php

if(!function_exists('wp_get_current_user')) {
	include_once(ABSPATH . "wp-includes/pluggable.php");
}

class EasySocialMetricsPro {
	private static $instance = null;	
	
	protected $version = ESMP_VERSION;
	protected $plugin_name = "Easy Social Metrics Pro for WordPress";
	protected $plugin_slug = "easy-social-metrics-pro";
		
	public static $plugin_settings_name = "easy-social-metrics-pro";
	
	public static $networks = array("facebook", "twitter", "google", "linkedin", "pinterest", "stumbleupon", "vk", "ok", "buffer", "del", "reddit");
	
	public function __construct() {
		global $pagenow;
		
		// register admin page
		add_action ( 'admin_menu', array ($this, 'init_menu' ) );
		add_action ( 'admin_enqueue_scripts', array ($this, 'register_admin_assets' ), 1 );
		
		$esmp_options = EasySocialMetricsPro_Options::get_instance();
		$metabox_admin = $esmp_options->get_options_key('metabox_admin');
		
		if (in_array( $pagenow, array( 'post.php' ))) {		
			
			$is_valid = true;
			
			if ($metabox_admin == 'true') {
				if (current_user_can('activate_plugins')) {
					$is_valid = true;
				}
				else {
					$is_valid = false;
				}
			}
			if ($is_valid) {
				add_action ( 'add_meta_boxes', array ($this, 'handle_esmp_metabox' ) );
			}
		}
		EasySocialMetricsPro_Updater::get_instance();
	}
	
	public static function get_instance() {
	
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
	
		return self::$instance;
	
	} // end get_instance;
	
	function register_admin_assets() {
		wp_register_style ( 'esmp-admin', ESMP_PLUGIN_URL . '/assets/css/esmp-admin-panel.css', array (), $this->version );
		wp_enqueue_style ( 'esmp-admin' );
		wp_register_style ( 'esmp-font', ESMP_PLUGIN_URL . '/assets/css/esmp.css', array (), $this->version );
		wp_enqueue_style ( 'esmp-font' );
		wp_enqueue_script ( 'esmp-admin', ESMP_PLUGIN_URL . '/assets/js/esmp-admin-panel.js', array ('jquery' ), $this->version, true );
		
	}
	
	public function init_menu() {
		add_menu_page( 'Easy Social Metrics Pro', 'Easy Social Metrics Pro', 'manage_options', 'easy-social-metrics-pro', array($this, 'render_view_dashboard'), 'dashicons-chart-area', '30.597831' );
		add_submenu_page('easy-social-metrics-pro', 'Easy Social Metrics Pro', 'Dashboard', 'manage_options', 'easy-social-metrics-pro',  array($this, 'render_view_dashboard'));		
		add_submenu_page('easy-social-metrics-pro', 'Easy Social Metrics Pro', 'Configuration', 'manage_options', 'easy-social-metrics-pro-settings',  array($this, 'render_settings_page'));		
	}
	
	function render_settings_page() {
		include(ESMP_PLUGIN_ROOT . 'lib/settings/esmp-settings.php');
	}
	
	function render_view_dashboard() {
		wp_register_style ( 'esmp-morris', ESMP_PLUGIN_URL . '/assets/css/morris.css', array (), $this->version );
		wp_enqueue_style ( 'esmp-morris' );
		
		wp_enqueue_script ( 'esmp-morris', ESMP_PLUGIN_URL . '/assets/js/morris.min.js', array ('jquery' ), $this->version, true );
		wp_enqueue_script ( 'esmp-raphael', ESMP_PLUGIN_URL . '/assets/js/raphael-min.js', array ('jquery' ), $this->version, true );
		
		wp_enqueue_script ( 'esmp-datepicker-moment', ESMP_PLUGIN_URL . '/assets/js/moment.js', array ('jquery' ), $this->version, true );
		wp_enqueue_script ( 'esmp-datepicker', ESMP_PLUGIN_URL . '/assets/js/pikaday.js', array ('jquery' ), $this->version, true );
		//wp_enqueue_script('jquery-ui-datepicker');
	    //wp_register_style ( 'esmp-datepicker', ESMP_PLUGIN_URL . '/assets/css/jquery-ui-datepicker.css', array (), $this->version );
		wp_register_style ( 'esmp-datepicker', ESMP_PLUGIN_URL . '/assets/css/pikaday.css', array (), $this->version );
		wp_enqueue_style ( 'esmp-datepicker' );
		//wp_enqueue_style( 'jquery-ui-datepicker' );
		include(ESMP_PLUGIN_ROOT . 'lib/dashboard/esmp-dashboard.php');
	}
	
	public static function activate() {
		$esmp_options = EasySocialMetricsPro_Options::get_instance();
		$option = $esmp_options->options;
		if (! $option || empty ( $option )) {
			$esmp_options->install_default();
		}
		
		EasySocialMetricsPro::install();
	}
	
	public static function deactivate() {
		EasySocialMetricsPro_Updater::deactivateAllCronJobs();
	}
	
	public static function install() {
		global $wpdb;
	
		$sql = "";
	
		$table_name = $wpdb->prefix . ESMP_DATABASE_TABLE;
	
		$sql .= "CREATE TABLE $table_name (
		 esmp_id int(11) NOT NULL AUTO_INCREMENT,
  esmp_date date NOT NULL,
  esmp_blog_id varchar(10) NOT NULL,
  esmp_post_id varchar(10) NOT NULL,
  esmp_data text  NOT NULL,
  PRIMARY KEY (esmp_id),
  KEY esmp_date (esmp_date,esmp_blog_id,esmp_post_id)
		); ";
	
	
	
		require_once (ABSPATH . 'wp-admin/includes/upgrade.php');
				dbDelta ( $sql );
	}
	
	public function handle_esmp_metabox() {
		$esmp_options = EasySocialMetricsPro_Options::get_instance();
		$active_post_types = $esmp_options->get_options_key("post_type");
		$pts	 = get_post_types( array('public'=> true, 'show_ui' => true, '_builtin' => true) );
		$cpts	 = get_post_types( array('public'=> true, 'show_ui' => true, '_builtin' => false) );
	
		$turnoff_essb_advanced_box = isset($options['turnoff_essb_advanced_box']) ? $options['turnoff_essb_advanced_box'] : 'false';
		foreach ( $pts as $pt ) {
			if (in_array($pt, $active_post_types)) {
				add_meta_box('esmp_stat_metabox', __('Easy Social Metrics Pro', ESMP_TEXT_DOMAIN), 'esmp_register_settings_metabox', $pt, 'side', 'high');
			}
		}
		foreach ( $cpts as $cpt ) {
			if (in_array($cpt, $active_post_types)) {
				add_meta_box('esmp_stat_metabox', __('Easy Social Metrics Pro', ESMP_TEXT_DOMAIN), 'esmp_register_settings_metabox', $cpt, 'side', 'high');
			}
		}
	
	}
}

?>