<?php

class EasySocialMetricsPro_Options {
	public static $plugin_settings_name = "easy-social-metrics-pro";
	
	private static $instance = null;
	
	public $options = array();
	
	public static function get_instance() {
	
		if ( null == self::$instance ) {
			self::$instance = new self;
		}
	
		return self::$instance;
	
	} // end get_instance;
	
	function __construct() {
		$this->get_options();
	}
	
	function get_options() {
		$this->options = get_option ( self::$plugin_settings_name );
	}
	
	function default_options() {
		$options = array(
			'networks' => array(
					'facebook' => 'Facebook',
					'twitter' => 'Twitter',
					'google' => 'Google',
					'linkedin' => 'LinkedIn',
					'pinterest' => 'Pinterest',
					'stumble' => 'StumbleUpon',
					'reddit' => 'Reddit',
					'vk' => 'VKontakte',
					'ok' => 'Odnoklassniki',
					'xing' => 'Xing',
					'managewp' => 'ManageWP.org',
					'buffer' => 'Buffer'),
			'active_networks' => array(),
			'post_type' => array(),
			'ttl' => '24',
			'active' => 'false',
			'initial' => 'false',
			'last_full_update' => ''
				);
		
		return $options;
	}
	
	function set_initial_run_state ($state = 'true') {
		$this->get_options();
		$this->options['initial'] = 'true';
		update_option(self::$plugin_settings_name, $this->options);
	}
	
	function install_default() {
		$options = $this->default_options();
		
		update_option(self::$plugin_settings_name, $options);
	}
	
	function save_options($options) {
		update_option(self::$plugin_settings_name, $options);
		
	}
	
	function get_options_key($key) {
		$value = isset($this->options[$key]) ? $this->options[$key] : '';
		
		return $value;
	}
		
	
	function get_monitored_post_types() {
		$types_to_track = array ();
		
		$pts = get_post_types ( array ('public' => true, 'show_ui' => true, '_builtin' => true ) );
		$cpts = get_post_types ( array ('public' => true, 'show_ui' => true, '_builtin' => false ) );
		
		if (is_array ( $this->options )) {
			if (! isset ( $this->options ['post_type'] )) {
				$this->options ['post_type'] = array ();
			}
		}
		
		if (is_array ( $this->options ) && isset ( $this->options ['post_type'] ) && is_array ( $this->options ['post_type'] )) {
			
			global $wp_post_types;
			// classical post type listing
			foreach ( $pts as $pt ) {
				
				$selected = in_array ( $pt, $this->options ['post_type'] ) ? '1' : '0';
				
				if ($selected == '1') {
					$types_to_track [] = $pt;
				}
			
			}
			
			// custom post types listing
			if (is_array ( $cpts ) && ! empty ( $cpts )) {
				foreach ( $cpts as $cpt ) {
					
					$selected = in_array ( $cpt, $this->options ['post_type'] ) ? '1' : '0';
					
					if ($selected == '1') {
						$types_to_track [] = $cpt;
					}
				
				}
			}
		}
		
		return $types_to_track;
	
	}
	
	function get_monitored_post_types_named_list() {
		$types_to_track = array ();
	
		$pts = get_post_types ( array ('public' => true, 'show_ui' => true, '_builtin' => true ) );
		$cpts = get_post_types ( array ('public' => true, 'show_ui' => true, '_builtin' => false ) );
	
		if (is_array ( $this->options )) {
			if (! isset ( $this->options ['post_type'] )) {
				$this->options ['post_type'] = array ();
			}
		}
	
		if (is_array ( $this->options ) && isset ( $this->options ['post_type'] ) && is_array ( $this->options ['post_type'] )) {
				
			global $wp_post_types;
			// classical post type listing
			foreach ( $pts as $pt ) {
	
				$selected = in_array ( $pt, $this->options ['post_type'] ) ? '1' : '0';
	
				if ($selected == '1') {
					$types_to_track [$pt] = $wp_post_types [$pt]->label;
				}
					
			}
				
			// custom post types listing
			if (is_array ( $cpts ) && ! empty ( $cpts )) {
				foreach ( $cpts as $cpt ) {
						
					$selected = in_array ( $cpt, $this->options ['post_type'] ) ? '1' : '0';
						
					if ($selected == '1') {
						$types_to_track [$cpt] = $wp_post_types [$cpt]->label;
					}
	
				}
			}
		}
	
		return $types_to_track;
	
	}
}

?>