<?php

/*
 * Plugin Name: Easy Social Metrics Pro for WordPress
* Description: Track and analyze how your site is doing across the leading social networking websites and services including Facebook, Google, Twitter, LinkedIn, Pinterest, StumbleUpon, Reddit, VKontakte, Odnoklassniki, Xing, ManageWP.org, Buffer
* Plugin URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
* Version: 1.2
* Author: CreoApps
* Author URI: http://codecanyon.net/user/appscreo/portfolio?ref=appscreo
*/

if (! defined ( 'WPINC' ))
	die ();

//error_reporting( E_ALL | E_STRICT );

define ( 'ESMP_VERSION', '1.2' );
define ( 'ESMP_PLUGIN_ROOT', dirname ( __FILE__ ) . '/' );
define ( 'ESMP_PLUGIN_URL', plugins_url () . '/' . basename ( dirname ( __FILE__ ) ) );
define ( 'ESMP_PLUGIN_BASE_NAME', plugin_basename( __FILE__ ));
define ( 'ESMP_TEXT_DOMAIN', 'easy-social-metrics-pro');
define ( 'ESMP_DATABASE_TABLE', 'esmp_data');


include_once (ESMP_PLUGIN_ROOT . 'lib/class-esmp.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/class-esmp-options.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/esmp-metabox.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/helpers/class-esmp-settings-helper.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/helpers/class-esmp-database-helper.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/helpers/class-esmp-report-helper.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/helpers/class-esmp-updater.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/data-source/class-esmp-social.php');
include_once (ESMP_PLUGIN_ROOT . 'lib/data-source/class-esmp-dummy.php');
include(ESMP_PLUGIN_ROOT . 'lib/widget-top-posts/esmp-posts-widget.php');

global $esmp;
$esmp = EasySocialMetricsPro::get_instance();

register_activation_hook ( __FILE__, array ('EasySocialMetricsPro', 'activate' ) );
register_deactivation_hook ( __FILE__, array ('EasySocialMetricsPro', 'deactivate' ) );


?>